#include <ultra64.h>
#include "dynlist_macros.h"
#include "dynlists.h"
#include "animdata.h"
#include "../dynlist_proc.h"
#include "../shape_helper.h"

/* @ 04004F90 */
struct DynList dynlist_mario_master[1026] = {
    StartList(),
    UseIntId(TRUE),
    StartGroup(0x3E8),
    JumpToList(dynlist_mario_face),
    JumpToList(dynlist_mario_eye_right),
    JumpToList(dynlist_mario_eye_left),
    JumpToList(dynlist_mario_eyebrow_right),
    JumpToList(dynlist_mario_eyebrow_left),
    JumpToList(dynlist_mario_mustache),
    EndGroup(0x3E8),
    MakeDynObj(D_LIGHT, 0xE4),
    SetId(1),
    SetDiffuse(1.0, 1.0, 1.0),
    SetFlag(0x20),
    SetShapePtrPtr(&gShapeSilverStar),
    MakeDynObj(D_LIGHT, 0xE7),
    SetId(0),
    SetDiffuse(1.0, 0.0, 0.0),
    SetShapePtrPtr(&gShapeRedStar),
    StartGroup(0x1),
    MakeDynObj(D_NET, 0xDD),
    SetType(2),
    SetFlag(0x2),
    SetShapePtr(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(112.873, 0.0, 0.0),
    SetAttachOffset(0.0, 0.0, -20010.0),
    MakeNetWithSubGroup(0, 0xDA),
    AttachTo(0xd, 0xDD),
    SetSkinShape(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 90.0, 0.0),
    SetAttachOffset(116.3, 182.6, -70.2),
    AttachNetToJoint(0, 0xD7),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 162.007),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(7, 95.0),
    SetSkinWeight(8, 70.0),
    SetSkinWeight(48, 90.0),
    SetSkinWeight(49, 100.0),
    SetSkinWeight(128, 60.0),
    SetSkinWeight(131, 90.0),
    SetSkinWeight(132, 100.0),
    SetSkinWeight(133, 95.0),
    SetSkinWeight(134, 70.0),
    SetSkinWeight(428, 50.0),
    SetSkinWeight(429, 20.0),
    SetSkinWeight(51, 35.0),
    SetSkinWeight(124, 10.0),
    SetSkinWeight(126, 10.0),
    SetSkinWeight(127, 5.0),
    SetSkinWeight(130, 50.0),
    SetSkinWeight(135, 20.0),
    SetSkinWeight(136, 10.0),
    SetSkinWeight(423, 35.0),
    SetSkinWeight(46, 40.0),
    SetSkinWeight(47, 10.0),
    SetSkinWeight(82, 10.0),
    AttachNetToJoint(0, 0xD4),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(382.3, 0.0, 0.0),
    EndNetSubGroup(0xDA),
    MakeNetWithSubGroup(0, 0xD1),
    AttachTo(0xd, 0xDD),
    SetSkinShape(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 90.0, 0.0),
    SetAttachOffset(-116.3, 182.6, -70.2),
    AttachNetToJoint(0, 0xCE),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 162.007),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(196, 90.0),
    SetSkinWeight(375, 70.0),
    SetSkinWeight(392, 70.0),
    SetSkinWeight(393, 95.0),
    SetSkinWeight(394, 95.0),
    SetSkinWeight(395, 100.0),
    SetSkinWeight(396, 100.0),
    SetSkinWeight(397, 90.0),
    SetSkinWeight(399, 60.0),
    SetSkinWeight(428, 50.0),
    SetSkinWeight(429, 20.0),
    SetSkinWeight(197, 50.0),
    SetSkinWeight(385, 5.0),
    SetSkinWeight(388, 10.0),
    SetSkinWeight(389, 10.0),
    SetSkinWeight(390, 20.0),
    SetSkinWeight(391, 35.0),
    SetSkinWeight(398, 10.0),
    SetSkinWeight(419, 35.0),
    SetSkinWeight(400, 40.0),
    SetSkinWeight(374, 10.0),
    SetSkinWeight(387, 10.0),
    AttachNetToJoint(0, 0xCB),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(420.0, 0.0, 0.0),
    EndNetSubGroup(0xD1),
    MakeNetWithSubGroup(0, 0xC8),
    AttachTo(0xd, 0xDD),
    SetSkinShape(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 90.0, 0.0),
    SetAttachOffset(0.0, -154.9, 118.5),
    AttachNetToJoint(0, 0xC5),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, -111.558),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(98, 100.0),
    SetSkinWeight(104, 100.0),
    SetSkinWeight(189, 100.0),
    SetSkinWeight(358, 100.0),
    SetSkinWeight(5, 40.0),
    SetSkinWeight(10, 38.0),
    SetSkinWeight(380, 40.0),
    SetSkinWeight(405, 38.0),
    SetSkinWeight(39, 50.0),
    SetSkinWeight(117, 50.0),
    SetSkinWeight(337, 50.0),
    SetSkinWeight(11, 40.0),
    SetSkinWeight(379, 40.0),
    SetSkinWeight(105, 50.0),
    SetSkinWeight(116, 50.0),
    SetSkinWeight(406, 50.0),
    SetSkinWeight(85, 70.0),
    SetSkinWeight(86, 60.0),
    SetSkinWeight(111, 30.0),
    SetSkinWeight(159, 50.0),
    SetSkinWeight(357, 50.0),
    SetSkinWeight(416, 60.0),
    SetSkinWeight(6, 25.0),
    SetSkinWeight(407, 25.0),
    SetSkinWeight(408, 30.0),
    SetSkinWeight(4, 30.0),
    SetSkinWeight(410, 70.0),
    SetSkinWeight(409, 30.0),
    SetSkinWeight(109, 15.0),
    SetSkinWeight(355, 15.0),
    SetSkinWeight(35, 5.0),
    SetSkinWeight(372, 5.0),
    SetSkinWeight(376, 5.0),
    SetSkinWeight(110, 5.0),
    SetSkinWeight(16, 3.0),
    SetSkinWeight(17, 3.0),
    SetSkinWeight(34, 3.0),
    SetSkinWeight(373, 3.0),
    SetSkinWeight(381, 3.0),
    SetSkinWeight(383, 3.0),
    AttachNetToJoint(0, 0xC2),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, -31.153),
    SetAttachOffset(141.0, 0.0, 0.0),
    SetSkinWeight(31, 80.0),
    SetSkinWeight(32, 80.0),
    SetSkinWeight(39, 30.0),
    SetSkinWeight(40, 10.0),
    SetSkinWeight(99, 100.0),
    SetSkinWeight(100, 100.0),
    SetSkinWeight(105, 50.0),
    SetSkinWeight(113, 100.0),
    SetSkinWeight(114, 100.0),
    SetSkinWeight(115, 100.0),
    SetSkinWeight(116, 50.0),
    SetSkinWeight(117, 20.0),
    SetSkinWeight(177, 20.0),
    SetSkinWeight(336, 10.0),
    SetSkinWeight(337, 30.0),
    SetSkinWeight(406, 50.0),
    SetSkinWeight(411, 80.0),
    SetSkinWeight(412, 100.0),
    SetSkinWeight(413, 100.0),
    SetSkinWeight(414, 100.0),
    SetSkinWeight(415, 80.0),
    SetSkinWeight(418, 100.0),
    SetSkinWeight(409, 28.0),
    SetSkinWeight(86, 8.0),
    SetSkinWeight(416, 4.0),
    SetSkinWeight(4, 28.0),
    SetSkinWeight(5, 3.0),
    SetSkinWeight(10, 5.0),
    SetSkinWeight(380, 5.0),
    SetSkinWeight(405, 5.0),
    AttachNetToJoint(0, 0xBF),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(80.1, 0.0, 0.0),
    EndNetSubGroup(0xC8),
    MakeNetWithSubGroup(0, 0xBC),
    AttachTo(0xd, 0xDD),
    SetSkinShape(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 90.0, 0.0),
    SetAttachOffset(0.0, 15.3, 295.1),
    AttachNetToJoint(0, 0xB9),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, -178.586),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(15, 5.0),
    SetSkinWeight(18, 30.0),
    SetSkinWeight(23, 70.0),
    SetSkinWeight(24, 40.0),
    SetSkinWeight(25, 90.0),
    SetSkinWeight(26, 70.0),
    SetSkinWeight(27, 90.0),
    SetSkinWeight(28, 40.0),
    SetSkinWeight(29, 70.0),
    SetSkinWeight(30, 90.0),
    SetSkinWeight(41, 70.0),
    SetSkinWeight(160, 70.0),
    SetSkinWeight(161, 100.0),
    SetSkinWeight(182, 90.0),
    SetSkinWeight(183, 90.0),
    SetSkinWeight(346, 70.0),
    SetSkinWeight(347, 30.0),
    SetSkinWeight(348, 70.0),
    SetSkinWeight(349, 40.0),
    SetSkinWeight(350, 30.0),
    SetSkinWeight(351, 70.0),
    SetSkinWeight(352, 90.0),
    SetSkinWeight(353, 5.0),
    SetSkinWeight(386, 5.0),
    SetSkinWeight(430, 70.0),
    SetSkinWeight(431, 70.0),
    SetSkinWeight(433, 70.0),
    SetSkinWeight(434, 70.0),
    SetSkinWeight(435, 70.0),
    SetSkinWeight(436, 70.0),
    SetSkinWeight(437, 70.0),
    SetSkinWeight(439, 70.0),
    SetSkinWeight(19, 40.0),
    SetSkinWeight(20, 5.0),
    SetSkinWeight(21, 5.0),
    SetSkinWeight(22, 30.0),
    SetSkinWeight(82, 5.0),
    SetSkinWeight(83, 5.0),
    SetSkinWeight(87, 5.0),
    SetSkinWeight(384, 5.0),
    SetSkinWeight(387, 5.0),
    SetSkinWeight(432, 40.0),
    SetSkinWeight(438, 40.0),
    AttachNetToJoint(0, 0xB6),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(276.6, 0.0, 0.0),
    EndNetSubGroup(0xBC),
    MakeNetWithSubGroup(0, 0xB3),
    AttachTo(0xd, 0xDD),
    SetSkinShape(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-90.0, 0.0, 0.0),
    SetAttachOffset(294.7, 13.1, -82.1),
    AttachNetToJoint(0, 0xB0),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 26.565),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(59, 80.0),
    SetSkinWeight(60, 50.0),
    SetSkinWeight(61, 60.0),
    SetSkinWeight(65, 100.0),
    SetSkinWeight(66, 60.0),
    SetSkinWeight(88, 10.0),
    SetSkinWeight(89, 60.0),
    SetSkinWeight(90, 80.0),
    SetSkinWeight(91, 70.0),
    SetSkinWeight(92, 100.0),
    SetSkinWeight(118, 15.0),
    SetSkinWeight(119, 5.0),
    SetSkinWeight(120, 15.0),
    SetSkinWeight(122, 60.0),
    SetSkinWeight(123, 70.0),
    SetSkinWeight(137, 10.0),
    SetSkinWeight(138, 60.0),
    SetSkinWeight(139, 10.0),
    SetSkinWeight(140, 5.0),
    SetSkinWeight(141, 10.0),
    SetSkinWeight(167, 60.0),
    SetSkinWeight(168, 70.0),
    SetSkinWeight(224, 50.0),
    SetSkinWeight(225, 70.0),
    SetSkinWeight(226, 50.0),
    SetSkinWeight(227, 50.0),
    SetSkinWeight(228, 60.0),
    SetSkinWeight(229, 60.0),
    SetSkinWeight(235, 10.0),
    AttachNetToJoint(0, 0xAD),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(200.9, 0.0, 0.0),
    EndNetSubGroup(0xB3),
    MakeNetWithSubGroup(0, 0xAA),
    AttachTo(0xd, 0xDD),
    SetSkinShape(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(90.0, 180.0, 0.0),
    SetAttachOffset(-294.7, 13.1, -82.1),
    AttachNetToJoint(0, 0xA7),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(180.0, 180.0, -153.435),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(244, 5.0),
    SetSkinWeight(267, 5.0),
    SetSkinWeight(268, 5.0),
    SetSkinWeight(299, 5.0),
    SetSkinWeight(302, 5.0),
    SetSkinWeight(307, 70.0),
    SetSkinWeight(308, 70.0),
    SetSkinWeight(309, 100.0),
    SetSkinWeight(310, 70.0),
    SetSkinWeight(311, 70.0),
    SetSkinWeight(314, 100.0),
    SetSkinWeight(315, 70.0),
    SetSkinWeight(317, 80.0),
    SetSkinWeight(318, 70.0),
    SetSkinWeight(319, 80.0),
    SetSkinWeight(320, 70.0),
    SetSkinWeight(321, 10.0),
    SetSkinWeight(322, 10.0),
    SetSkinWeight(323, 10.0),
    SetSkinWeight(324, 10.0),
    SetSkinWeight(325, 60.0),
    SetSkinWeight(326, 100.0),
    SetSkinWeight(327, 100.0),
    SetSkinWeight(328, 100.0),
    SetSkinWeight(329, 80.0),
    SetSkinWeight(330, 80.0),
    SetSkinWeight(331, 60.0),
    SetSkinWeight(332, 70.0),
    SetSkinWeight(340, 70.0),
    AttachNetToJoint(0, 0xA4),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.02),
    SetAttachOffset(200.9, 0.0, 0.0),
    EndNetSubGroup(0xAA),
    MakeNetWithSubGroup(0, 0xA1),
    AttachTo(0xd, 0xDD),
    SetSkinShape(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-90.0, 0.0, 0.0),
    SetAttachOffset(119.7, -161.4, 125.5),
    AttachNetToJoint(0, 0x9E),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-0.02, 0.0, -66.509),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(4, 42.0),
    SetSkinWeight(5, 40.0),
    SetSkinWeight(6, 75.0),
    SetSkinWeight(10, 30.0),
    SetSkinWeight(11, 40.0),
    SetSkinWeight(16, 20.0),
    SetSkinWeight(17, 15.0),
    SetSkinWeight(33, 30.0),
    SetSkinWeight(34, 20.0),
    SetSkinWeight(35, 60.0),
    SetSkinWeight(37, 10.0),
    SetSkinWeight(43, 40.0),
    SetSkinWeight(85, 30.0),
    SetSkinWeight(86, 30.0),
    SetSkinWeight(93, 30.0),
    SetSkinWeight(94, 10.0),
    SetSkinWeight(101, 100.0),
    SetSkinWeight(103, 100.0),
    SetSkinWeight(108, 10.0),
    SetSkinWeight(109, 70.0),
    SetSkinWeight(110, 80.0),
    SetSkinWeight(111, 60.0),
    SetSkinWeight(112, 70.0),
    SetSkinWeight(159, 50.0),
    SetSkinWeight(42, 30.0),
    SetSkinWeight(102, 30.0),
    SetSkinWeight(31, 20.0),
    SetSkinWeight(32, 20.0),
    SetSkinWeight(44, 15.0),
    AttachNetToJoint(0, 0x9B),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.028, 0.0, 0.0),
    SetAttachOffset(184.5, 0.0, 0.0),
    EndNetSubGroup(0xA1),
    MakeNetWithSubGroup(0, 0x98),
    AttachTo(0xd, 0xDD),
    SetSkinShape(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(90.0, 180.0, 0.0),
    SetAttachOffset(-119.7, -161.4, 125.5),
    AttachNetToJoint(0, 0x95),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.02, 0.0, -66.509),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(187, 100.0),
    SetSkinWeight(273, 30.0),
    SetSkinWeight(342, 10.0),
    SetSkinWeight(354, 40.0),
    SetSkinWeight(355, 70.0),
    SetSkinWeight(356, 70.0),
    SetSkinWeight(357, 50.0),
    SetSkinWeight(371, 10.0),
    SetSkinWeight(372, 60.0),
    SetSkinWeight(373, 20.0),
    SetSkinWeight(376, 80.0),
    SetSkinWeight(377, 100.0),
    SetSkinWeight(378, 10.0),
    SetSkinWeight(379, 40.0),
    SetSkinWeight(380, 30.0),
    SetSkinWeight(381, 15.0),
    SetSkinWeight(383, 20.0),
    SetSkinWeight(404, 30.0),
    SetSkinWeight(405, 30.0),
    SetSkinWeight(407, 75.0),
    SetSkinWeight(408, 60.0),
    SetSkinWeight(409, 42.0),
    SetSkinWeight(410, 30.0),
    SetSkinWeight(416, 36.0),
    SetSkinWeight(199, 15.0),
    SetSkinWeight(415, 20.0),
    SetSkinWeight(411, 20.0),
    SetSkinWeight(188, 20.0),
    SetSkinWeight(198, 20.0),
    AttachNetToJoint(0, 0x92),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-0.028, 0.0, 0.0),
    SetAttachOffset(184.5, 0.0, 0.0),
    EndNetSubGroup(0x98),
    MakeNetWithSubGroup(0, 0x8F),
    AttachTo(0xd, 0xDD),
    SetSkinShape(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 90.0, 0.0),
    SetAttachOffset(0.0, -162.2, 121.0),
    AttachNetToJoint(0, 0x8C),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, -176.775),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(42, 70.0),
    SetSkinWeight(44, 85.0),
    SetSkinWeight(102, 70.0),
    SetSkinWeight(188, 80.0),
    SetSkinWeight(198, 80.0),
    SetSkinWeight(199, 85.0),
    AttachNetToJoint(0, 0x89),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(242.8, 0.0, 0.0),
    EndNetSubGroup(0x8F),
    MakeNetWithSubGroup(0, 0x86),
    AttachTo(0xd, 0xDD),
    SetSkinShape(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 90.0, 0.0),
    SetAttachOffset(0.0, 233.8, -148.8),
    AttachNetToJoint(0, 0x83),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 153.932),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(68, 90.0),
    SetSkinWeight(69, 100.0),
    SetSkinWeight(70, 100.0),
    SetSkinWeight(71, 100.0),
    SetSkinWeight(75, 100.0),
    SetSkinWeight(76, 100.0),
    SetSkinWeight(77, 100.0),
    SetSkinWeight(79, 80.0),
    SetSkinWeight(129, 100.0),
    SetSkinWeight(147, 90.0),
    SetSkinWeight(148, 90.0),
    SetSkinWeight(149, 100.0),
    SetSkinWeight(150, 100.0),
    SetSkinWeight(151, 100.0),
    SetSkinWeight(154, 100.0),
    SetSkinWeight(155, 100.0),
    SetSkinWeight(156, 100.0),
    SetSkinWeight(157, 100.0),
    SetSkinWeight(184, 100.0),
    SetSkinWeight(185, 100.0),
    SetSkinWeight(192, 100.0),
    SetSkinWeight(193, 90.0),
    SetSkinWeight(194, 80.0),
    SetSkinWeight(195, 100.0),
    SetSkinWeight(201, 100.0),
    SetSkinWeight(202, 100.0),
    SetSkinWeight(230, 100.0),
    SetSkinWeight(360, 100.0),
    SetSkinWeight(361, 100.0),
    SetSkinWeight(362, 100.0),
    SetSkinWeight(363, 100.0),
    SetSkinWeight(364, 100.0),
    SetSkinWeight(366, 100.0),
    SetSkinWeight(367, 90.0),
    SetSkinWeight(368, 100.0),
    SetSkinWeight(369, 90.0),
    SetSkinWeight(420, 100.0),
    SetSkinWeight(421, 100.0),
    SetSkinWeight(422, 100.0),
    SetSkinWeight(424, 100.0),
    SetSkinWeight(425, 100.0),
    SetSkinWeight(426, 100.0),
    SetSkinWeight(427, 100.0),
    SetSkinWeight(58, 100.0),
    SetSkinWeight(242, 100.0),
    SetSkinWeight(0, 100.0),
    SetSkinWeight(1, 100.0),
    SetSkinWeight(2, 80.0),
    SetSkinWeight(9, 100.0),
    SetSkinWeight(50, 100.0),
    SetSkinWeight(54, 100.0),
    SetSkinWeight(55, 100.0),
    SetSkinWeight(56, 100.0),
    SetSkinWeight(57, 100.0),
    SetSkinWeight(67, 80.0),
    SetSkinWeight(78, 90.0),
    SetSkinWeight(80, 100.0),
    SetSkinWeight(121, 100.0),
    SetSkinWeight(142, 50.0),
    SetSkinWeight(145, 80.0),
    SetSkinWeight(146, 100.0),
    SetSkinWeight(152, 90.0),
    SetSkinWeight(158, 90.0),
    SetSkinWeight(186, 100.0),
    SetSkinWeight(240, 80.0),
    SetSkinWeight(246, 100.0),
    SetSkinWeight(247, 100.0),
    SetSkinWeight(248, 50.0),
    SetSkinWeight(249, 90.0),
    SetSkinWeight(251, 100.0),
    SetSkinWeight(303, 90.0),
    SetSkinWeight(304, 100.0),
    SetSkinWeight(305, 100.0),
    SetSkinWeight(306, 100.0),
    SetSkinWeight(335, 100.0),
    SetSkinWeight(338, 100.0),
    SetSkinWeight(345, 100.0),
    SetSkinWeight(359, 90.0),
    SetSkinWeight(365, 100.0),
    SetSkinWeight(370, 80.0),
    SetSkinWeight(401, 100.0),
    SetSkinWeight(402, 100.0),
    SetSkinWeight(403, 100.0),
    SetSkinWeight(417, 80.0),
    SetSkinWeight(125, 60.0),
    SetSkinWeight(143, 50.0),
    SetSkinWeight(270, 50.0),
    SetSkinWeight(294, 60.0),
    SetSkinWeight(239, 50.0),
    SetSkinWeight(245, 50.0),
    AttachNetToJoint(0, 0x80),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(528.3, 0.0, 0.0),
    EndNetSubGroup(0x86),
    MakeNetWithSubGroup(0, 0x7D),
    AttachTo(0xd, 0xDD),
    SetSkinShape(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(90.0, 180.0, 0.0),
    SetAttachOffset(29.7, 192.4, -3.0),
    AttachNetToJoint(0, 0x7A),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(184.483, -178.885, 82.485),
    SetAttachOffset(0.0, 0.0, 0.0),
    AttachNetToJoint(0, 0x77),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(329.8, 0.0, 0.0),
    EndNetSubGroup(0x7D),
    MakeDynObj(D_NET, 0x70),
    SetType(3),
    SetShapePtr(0x74),
    AttachTo(0xd, 0x7A),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(0.0, 0.0, 0.0),
    MakeNetWithSubGroup(0, 0x6D),
    AttachTo(0xd, 0xDD),
    SetSkinShape(0xE1),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-90.0, 0.0, 0.0),
    SetAttachOffset(-29.0, 192.3, -2.0),
    AttachNetToJoint(0, 0x6A),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-6.873, 0.206, -97.461),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(429, 16.0),
    AttachNetToJoint(0, 0x67),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(329.8, 0.0, 0.0),
    EndNetSubGroup(0x6D),
    MakeDynObj(D_NET, 0x60),
    SetType(3),
    SetShapePtr(0x64),
    AttachTo(0xd, 0x6A),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(0.0, 0.0, 0.0),
    MakeDynObj(D_NET, 0x59),
    SetType(2),
    SetShapePtr(0x5D),
    AttachTo(0xd, 0xDD),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(20.8, 0.0, -8.5),
    MakeNetWithSubGroup(0, 0x56),
    AttachTo(0xd, 0x59),
    SetSkinShape(0x5D),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-90.0, 90.0, -90.0),
    SetAttachOffset(231.3, 287.1, -51.4),
    AttachNetToJoint(0, 0x53),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(10.886, 0.0, 177.51),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(5, 70.0),
    SetSkinWeight(6, 80.0),
    SetSkinWeight(7, 70.0),
    SetSkinWeight(8, 50.0),
    SetSkinWeight(11, 70.0),
    SetSkinWeight(12, 100.0),
    SetSkinWeight(19, 50.0),
    SetSkinWeight(20, 80.0),
    SetSkinWeight(23, 70.0),
    AttachNetToJoint(0, 0x50),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(345.5, 0.0, 0.0),
    EndNetSubGroup(0x56),
    MakeNetWithSubGroup(0, 0x4D),
    AttachTo(0xd, 0x59),
    SetSkinShape(0x5D),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-90.0, 90.0, -90.0),
    SetAttachOffset(23.0, 305.5, -44.6),
    AttachNetToJoint(0, 0x4A),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-3.437, -0.069, -177.758),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(16, 80.0),
    SetSkinWeight(17, 100.0),
    SetSkinWeight(18, 80.0),
    SetSkinWeight(22, 70.0),
    SetSkinWeight(24, 50.0),
    SetSkinWeight(25, 80.0),
    SetSkinWeight(15, 30.0),
    AttachNetToJoint(0, 0x47),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(399.5, 0.0, 0.0),
    EndNetSubGroup(0x4D),
    MakeNetWithSubGroup(0, 0x44),
    AttachTo(0xd, 0x59),
    SetSkinShape(0x5D),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-90.0, 90.0, -90.0),
    SetAttachOffset(123.1, 385.5, -46.4),
    AttachNetToJoint(0, 0x41),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(2.865, 0.029, 182.377),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(0, 100.0),
    SetSkinWeight(1, 100.0),
    SetSkinWeight(2, 100.0),
    SetSkinWeight(3, 100.0),
    SetSkinWeight(4, 100.0),
    SetSkinWeight(9, 100.0),
    SetSkinWeight(10, 100.0),
    SetSkinWeight(13, 100.0),
    SetSkinWeight(14, 100.0),
    SetSkinWeight(15, 70.0),
    SetSkinWeight(21, 100.0),
    SetSkinWeight(16, 20.0),
    SetSkinWeight(18, 20.0),
    SetSkinWeight(22, 30.0),
    SetSkinWeight(25, 20.0),
    SetSkinWeight(6, 20.0),
    SetSkinWeight(11, 30.0),
    SetSkinWeight(20, 20.0),
    SetSkinWeight(23, 30.0),
    SetSkinWeight(5, 30.0),
    SetSkinWeight(7, 30.0),
    SetSkinWeight(8, 50.0),
    SetSkinWeight(19, 50.0),
    SetSkinWeight(24, 50.0),
    AttachNetToJoint(0, 0x3E),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(388.6, 0.0, 0.0),
    EndNetSubGroup(0x44),
    MakeDynObj(D_NET, 0x37),
    SetType(2),
    SetShapePtr(0x3B),
    AttachTo(0xd, 0xDD),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(-18.5, 0.0, -1.0),
    MakeNetWithSubGroup(0, 0x34),
    AttachTo(0xd, 0x37),
    SetSkinShape(0x3B),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 90.0, 0.0),
    SetAttachOffset(-233.6, 287.1, -51.4),
    AttachNetToJoint(0, 0x31),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-6.876, 0.0, 177.51),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(9, 100.0),
    SetSkinWeight(10, 80.0),
    SetSkinWeight(11, 80.0),
    SetSkinWeight(13, 80.0),
    SetSkinWeight(14, 80.0),
    SetSkinWeight(18, 60.0),
    SetSkinWeight(21, 60.0),
    SetSkinWeight(25, 60.0),
    AttachNetToJoint(0, 0x2E),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(345.5, 0.0, 0.0),
    EndNetSubGroup(0x34),
    MakeNetWithSubGroup(0, 0x2B),
    AttachTo(0xd, 0x37),
    SetSkinShape(0x3B),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 90.0, 0.0),
    SetAttachOffset(-25.3, 305.5, -44.6),
    AttachNetToJoint(0, 0x28),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-9.733, -0.388, -177.186),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(0, 70.0),
    SetSkinWeight(1, 100.0),
    SetSkinWeight(2, 70.0),
    SetSkinWeight(3, 70.0),
    SetSkinWeight(5, 50.0),
    SetSkinWeight(12, 70.0),
    SetSkinWeight(19, 30.0),
    SetSkinWeight(15, 30.0),
    AttachNetToJoint(0, 0x25),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(399.5, 0.0, 0.0),
    EndNetSubGroup(0x2B),
    MakeNetWithSubGroup(0, 0x22),
    AttachTo(0xd, 0x37),
    SetSkinShape(0x3B),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 90.0, 0.0),
    SetAttachOffset(-125.4, 385.5, -46.4),
    AttachNetToJoint(0, 0x1F),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-8.004, -0.61, 181.847),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(4, 70.0),
    SetSkinWeight(6, 100.0),
    SetSkinWeight(7, 100.0),
    SetSkinWeight(8, 80.0),
    SetSkinWeight(15, 70.0),
    SetSkinWeight(16, 80.0),
    SetSkinWeight(17, 100.0),
    SetSkinWeight(19, 70.0),
    SetSkinWeight(20, 80.0),
    SetSkinWeight(22, 80.0),
    SetSkinWeight(23, 60.0),
    SetSkinWeight(24, 100.0),
    SetSkinWeight(5, 50.0),
    SetSkinWeight(0, 30.0),
    SetSkinWeight(2, 30.0),
    SetSkinWeight(10, 20.0),
    SetSkinWeight(11, 20.0),
    SetSkinWeight(13, 20.0),
    SetSkinWeight(14, 20.0),
    SetSkinWeight(18, 40.0),
    SetSkinWeight(21, 40.0),
    SetSkinWeight(25, 40.0),
    SetSkinWeight(3, 30.0),
    SetSkinWeight(12, 30.0),
    AttachNetToJoint(0, 0x1C),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(388.6, 0.0, 0.0),
    EndNetSubGroup(0x22),
    MakeDynObj(D_NET, 0x15),
    SetType(2),
    SetShapePtr(0x19),
    AttachTo(0xd, 0xDD),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.02, -0.002, 0.04),
    SetAttachOffset(0.0, 0.0, 0.0),
    MakeNetWithSubGroup(0, 0x12),
    AttachTo(0xd, 0x15),
    SetSkinShape(0x19),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 180.0, 0.0),
    SetAttachOffset(4.2, -86.5, 415.5),
    AttachNetToJoint(0, 0xF),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-179.98, -164.53, -29.34),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(3, 50.0),
    SetSkinWeight(4, 50.0),
    SetSkinWeight(5, 50.0),
    SetSkinWeight(11, 70.0),
    SetSkinWeight(12, 80.0),
    SetSkinWeight(13, 70.0),
    SetSkinWeight(18, 80.0),
    SetSkinWeight(19, 80.0),
    SetSkinWeight(20, 80.0),
    SetSkinWeight(21, 100.0),
    SetSkinWeight(22, 100.0),
    SetSkinWeight(23, 100.0),
    SetSkinWeight(25, 100.0),
    SetSkinWeight(27, 100.0),
    SetSkinWeight(28, 50.0),
    SetSkinWeight(29, 40.0),
    SetSkinWeight(30, 40.0),
    SetSkinWeight(31, 100.0),
    SetSkinWeight(36, 50.0),
    SetSkinWeight(37, 50.0),
    SetSkinWeight(42, 40.0),
    SetSkinWeight(45, 50.0),
    SetSkinWeight(46, 50.0),
    SetSkinWeight(47, 80.0),
    SetSkinWeight(50, 40.0),
    SetSkinWeight(51, 100.0),
    SetSkinWeight(53, 40.0),
    SetSkinWeight(54, 80.0),
    AttachNetToJoint(0, 0xC),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(-0.028, 0.0, 0.02),
    SetAttachOffset(292.7, 0.0, 0.0),
    EndNetSubGroup(0x12),
    MakeNetWithSubGroup(0, 0x9),
    AttachTo(0xd, 0x15),
    SetSkinShape(0x19),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(-4.2, -86.5, 415.5),
    AttachNetToJoint(0, 0x6),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 15.47, 150.66),
    SetAttachOffset(0.0, 0.0, 0.0),
    SetSkinWeight(0, 100.0),
    SetSkinWeight(1, 80.0),
    SetSkinWeight(2, 80.0),
    SetSkinWeight(6, 100.0),
    SetSkinWeight(7, 100.0),
    SetSkinWeight(8, 50.0),
    SetSkinWeight(9, 50.0),
    SetSkinWeight(10, 50.0),
    SetSkinWeight(14, 50.0),
    SetSkinWeight(15, 50.0),
    SetSkinWeight(16, 50.0),
    SetSkinWeight(17, 80.0),
    SetSkinWeight(24, 100.0),
    SetSkinWeight(26, 100.0),
    SetSkinWeight(32, 80.0),
    SetSkinWeight(33, 100.0),
    SetSkinWeight(34, 70.0),
    SetSkinWeight(35, 50.0),
    SetSkinWeight(38, 40.0),
    SetSkinWeight(39, 40.0),
    SetSkinWeight(40, 40.0),
    SetSkinWeight(41, 50.0),
    SetSkinWeight(43, 50.0),
    SetSkinWeight(44, 50.0),
    SetSkinWeight(48, 80.0),
    SetSkinWeight(49, 70.0),
    SetSkinWeight(52, 40.0),
    SetSkinWeight(55, 80.0),
    AttachNetToJoint(0, 0x3),
    SetScale(1.0, 1.0, 1.0),
    SetRotation(0.0, 0.0, 0.0),
    SetAttachOffset(292.7, 0.0, 0.0),
    EndNetSubGroup(0x9),

    MakeDynObj(D_DATA_GRP, 0x7), // mustache right
    LinkWithPtr(&anim_mario_mustache_right),
    MakeDynObj(D_ANIMATOR, 0x8),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x7),
    LinkWith(0x6),

    MakeDynObj(D_DATA_GRP, 0x10), // mustache left
    LinkWithPtr(&anim_mario_mustache_left),
    MakeDynObj(D_ANIMATOR, 0x11),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x10),
    LinkWith(0xF),

    MakeDynObj(D_DATA_GRP, 0x20), // lips
    LinkWithPtr(&anim_mario_lips_1),
    MakeDynObj(D_ANIMATOR, 0x21),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x20),
    LinkWith(0x1F),

    MakeDynObj(D_DATA_GRP, 0x29), // lips
    LinkWithPtr(&anim_mario_lips_2),
    MakeDynObj(D_ANIMATOR, 0x2A),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x29),
    LinkWith(0x28),

    MakeDynObj(D_DATA_GRP, 0x32), // eyebrows
    LinkWithPtr(&anim_mario_eyebrows_1),
    MakeDynObj(D_ANIMATOR, 0x33),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x32),
    LinkWith(0x31),

    MakeDynObj(D_DATA_GRP, 0x3F), // eyebrows equalizer
    LinkWithPtr(&anim_mario_eyebrows_equalizer),
    MakeDynObj(D_ANIMATOR, 0x40),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x3F),
    LinkWith(0x3E),

    MakeDynObj(D_DATA_GRP, 0x42), // eyebrows
    LinkWithPtr(&anim_mario_eyebrows_2),
    MakeDynObj(D_ANIMATOR, 0x43),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x42),
    LinkWith(0x41),

    MakeDynObj(D_DATA_GRP, 0x48), // eyebrows
    LinkWithPtr(&anim_mario_eyebrows_3),
    MakeDynObj(D_ANIMATOR, 0x49),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x48),
    LinkWith(0x47),

    MakeDynObj(D_DATA_GRP, 0x4B), // eyebrows
    LinkWithPtr(&anim_mario_eyebrows_4),
    MakeDynObj(D_ANIMATOR, 0x4C),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x4B),
    LinkWith(0x4A),

    MakeDynObj(D_DATA_GRP, 0x54), // eyebrows
    LinkWithPtr(&anim_mario_eyebrows_5),
    MakeDynObj(D_ANIMATOR, 0x55),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x54),
    LinkWith(0x53),

    MakeDynObj(D_DATA_GRP, 0x6B), // left eye
    LinkWithPtr(&anim_mario_eye_left),
    MakeDynObj(D_ANIMATOR, 0x6C),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x6B),
    LinkWith(0x6A),

    MakeDynObj(D_DATA_GRP, 0x7B), // right eye
    LinkWithPtr(&anim_mario_eye_right),
    MakeDynObj(D_ANIMATOR, 0x7C),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x7B),
    LinkWith(0x7A),

    MakeDynObj(D_DATA_GRP, 0x84), // hat
    LinkWithPtr(&anim_mario_hat),
    MakeDynObj(D_ANIMATOR, 0x85),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x84),
    LinkWith(0x83),

    MakeDynObj(D_DATA_GRP, 0x96), // upper lip left
    LinkWithPtr(&anim_mario_lips_3),
    MakeDynObj(D_ANIMATOR, 0x97),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x96),
    LinkWith(0x95),

    MakeDynObj(D_DATA_GRP, 0x9F), // upper lip right
    LinkWithPtr(&anim_mario_lips_4),
    MakeDynObj(D_ANIMATOR, 0xA0),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0x9F),
    LinkWith(0x9E),

    MakeDynObj(D_DATA_GRP, 0xA8), // left ear
    LinkWithPtr(&anim_mario_ear_left),
    MakeDynObj(D_ANIMATOR, 0xA9),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0xA8),
    LinkWith(0xA7),

    MakeDynObj(D_DATA_GRP, 0xB1), // right ear
    LinkWithPtr(&anim_mario_ear_right),
    MakeDynObj(D_ANIMATOR, 0xB2),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0xB1),
    LinkWith(0xB0),

    MakeDynObj(D_DATA_GRP, 0xBA), // nose
    LinkWithPtr(&anim_mario_nose),
    MakeDynObj(D_ANIMATOR, 0xBB),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0xBA),
    LinkWith(0xB9),

    MakeDynObj(D_DATA_GRP, 0xC3), // lip
    LinkWithPtr(&anim_mario_lips_5),
    MakeDynObj(D_ANIMATOR, 0xC4),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0xC3),
    LinkWith(0xC2),

    MakeDynObj(D_DATA_GRP, 0xC6), // lip
    LinkWithPtr(&anim_mario_lips_6),
    MakeDynObj(D_ANIMATOR, 0xC7),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0xC6),
    LinkWith(0xC5),

    MakeDynObj(D_DATA_GRP, 0xCF), // left eyelid
    LinkWithPtr(&anim_mario_eyelid_left),
    MakeDynObj(D_ANIMATOR, 0xD0),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0xCF),
    LinkWith(0xCE),

    MakeDynObj(D_DATA_GRP, 0xD8), // right eyelid
    LinkWithPtr(&anim_mario_eyelid_right),
    MakeDynObj(D_ANIMATOR, 0xD9),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0xD8),
    LinkWith(0xD7),

    MakeDynObj(D_DATA_GRP, 0xE2), // intro
    LinkWithPtr(&anim_mario_intro),
    MakeDynObj(D_ANIMATOR, 0xE3),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0xE2),
    LinkWith(0xDD),

    MakeDynObj(D_DATA_GRP, 0xE5), // silver star
    LinkWithPtr(&anim_silver_star),
    MakeDynObj(D_ANIMATOR, 0xE6),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0xE5),
    LinkWith(0xE4),

    MakeDynObj(D_DATA_GRP, 0xE8), // red star
    LinkWithPtr(&anim_red_star),
    MakeDynObj(D_ANIMATOR, 0xE9),
    AttachTo(0x0, 0x3E9),
    SetNodeGroup(0xE8),
    LinkWith(0xE7),

    EndGroup(0x1),
    UseObj(0x1),
    UseIntId(FALSE),
    StopList(),
};
